<?php namespace App\Controllers\Api\Customer\Projects\Builds;

use App\Controllers\PrivateController;
use App\Models\AppsModel;
use App\Models\BuildsModel;
use App\Models\SubscribesModel;
use App\Models\PlansModel;
use CodeIgniter\HTTP\ResponseInterface;

class BuildsList extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    public function index(): ResponseInterface
    {
        $uid = esc($this->request->getGet("uid"));

        $projects = new AppsModel();

        $app = $projects
            ->where("uid", $uid)
            ->where("user", $this->userId)
            ->where("deleted_at", 0)
            ->select("id")
            ->first();

        if (!$app) {
            return $this->respond(["message" => lang("Message.message_14")], 404);
        }

        $subscribes = new SubscribesModel();
        $subscribe = $subscribes
            ->where("app_id", $app["id"])
            ->where("expires_at >", time())
            ->where("is_disable", 0)
            ->select("expires_at, plan_id, remaining_count, id")
            ->first();

        $builds = new BuildsModel();
        $items = $builds
            ->where("app_id", $app["id"])
            ->orderBy("id", "DESC")
            ->findAll();

        $list = [];
        foreach ($items as $build) {
            $list[] = [
                "uid"      => $build["uid"],
                "platform" => $build["platform"],
                "status"   => (int) $build["status"],
                "version"  => $build["version"],
                "publish"  => (int) $build["publish"],
                "created"  => date('d-m-Y H:i', $build['created_at']),
                "format"   => $build["platform"] == "ios" ? "ipa" : $build["format"],
                "fail"     => (bool) $build["fail"],
                "message"  => $build["message"]
            ];
        }

        // Khởi tạo giá trị mặc định cho remaining_count và build_count
        $remaining_count = $subscribe['remaining_count'] ?? 0; // Khởi tạo là 0
        $build_count = 0;

        $plans = new PlansModel();
        if ($subscribe && isset($subscribe['plan_id'])) {
            $plan = $plans->find($subscribe['plan_id']);
            if ($plan) { 
                $build_count = $plan['build_count'] ?? 0;

                // Trường hợp 1: Khách hàng vừa mua gói nhưng chưa build app
                if ($remaining_count == 0 && $build_count > 0) { // Nếu không có lượt build
                    $remaining_count = $build_count; 
                    $subscribes->update($subscribe['id'], ['remaining_count' => $remaining_count]);
                    log_message('info', "Đã cập nhật remaining_count cho subscribe ID {$subscribe['id']}: $remaining_count");
                }
              
              	// Trường hợp 2: Khách hàng đã build app
                if ($remaining_count > 0) {
                    $existing_builds = $builds->where("app_id", $app["id"])->countAllResults();
                    if ($existing_builds > 0) {
                        // Nếu remaining_count chỉ còn 1 lượt cuối
                        if ($remaining_count == 1) {
                            // Khi khách chọn build app
                            $remaining_count = 0; // Giảm xuống 0
                            $subscribes->update($subscribe['id'], ['remaining_count' => $remaining_count]);

                            log_message('info', "Đã giảm remaining_count xuống 0 cho subscribe ID {$subscribe['id']}");

                            // Dừng lại để không thực hiện case 1
                            return $this->respond(["list" => $list, "remaining_count" => $remaining_count, "build_count" => $build_count], 200);
                        }
                    }
                }
            }
        }

        

        return $this->respond(["list" => $list, "remaining_count" => $remaining_count, "build_count" => $build_count], 200);
    }
}